/*
 * Decompiled with CFR 0.152.
 */
package visualizer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import visualizer.MetaData;
import visualizer.Utils;

public class FmowVisualizer
implements ActionListener,
MouseListener {
    private static final String FALSE_DETECTION = "false_detection";
    private static final String FALSE_DETECTION_ALIAS = "unknown";
    private static final String TITLE = "fMoW Visualizer";
    public static final String ARROW = " \u21d2 ";
    public static final String TOC_FILE_NAME = "toc.txt";
    private boolean createTOC = false;
    private PrintWriter tocWriter = null;
    private boolean hasGui = true;
    private String dataDir;
    private Map<String, Metrics> categoryToScore;
    private Map<Integer, String> boxIdToCategory;
    private Map<Integer, String> boxIdToGuess;
    private Map<Integer, String> boxIdToSceneId;
    private Map<String, Scene> sceneIdToScene;
    private Scene[] scenes;
    private Set<String> categorySet;
    private Map<String, Double> categoryWeights;
    private Scene currentScene;
    private MapData currentMapData;
    private Box[] currentBoxes;
    private double currentGsd;
    private String solutionPath;
    private int maxNperCategory = Integer.MAX_VALUE;
    private boolean useMsData = true;
    private String sceneFilter = null;
    private Pattern sceneFilterPattern = null;
    private GsonBuilder jsonBuilder;
    private Gson gson;
    private boolean writeSolution = false;
    private double scale;
    private double x0 = 0.0;
    private double y0 = 0.0;
    private double[] rulerLengths = new double[]{1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 500.0, 1000.0, 2000.0, 5000.0, 10000.0};
    private String[] rulerLabels = new String[]{"Come on, this is not a microscope!", "2m", "5m", "10m", "20m", "50m", "100m", "200m", "500m", "1km", "2km", "5km", "10km"};
    private int rulerIndex;
    private JFrame frame;
    private JPanel viewPanel;
    private JPanel controlsPanel;
    private JCheckBox showBoxesCb;
    private JCheckBox showLabelsCb;
    private JCheckBox showBoxIdsCb;
    private JCheckBox errorsOnlyCb;
    private JLabel xyInfoLabel;
    private JTextArea logArea;
    private JTextArea infoArea;
    private MapView mapView;
    private Font font = new Font("SansSerif", 1, 16);
    private Color textColor = Color.black;
    private Color borderColorBlack = new Color(0, 0, 0, 200);
    private Color borderColorWhite = new Color(255, 255, 255, 200);

    private void run() throws Exception {
        String cat;
        String categories = "airport,airport_hangar,airport_terminal,amusement_park,aquaculture,archaeological_site,barn,border_checkpoint,burial_site,car_dealership,construction_site,crop_field,dam,debris_or_rubble,educational_institution,electric_substation,factory_or_powerplant,fire_station,flooded_road,fountain,gas_station,golf_course,ground_transportation_station,helipad,hospital,impoverished_settlement,interchange,lake_or_pond,lighthouse,military_facility,multi-unit_residential,nuclear_powerplant,office_building,oil_or_gas_facility,park,parking_lot_or_garage,place_of_worship,police_station,port,prison,race_track,railway_bridge,recreational_facility,road_bridge,runway,shipyard,shopping_mall,single-unit_residential,smokestack,solar_farm,space_facility,stadium,storage_tank,surface_mine,swimming_pool,toll_booth,tower,tunnel_opening,waste_disposal,water_treatment_facility,wind_farm,zoo";
        String[] catArr = categories.split(",");
        this.categorySet = new HashSet<String>();
        this.categoryWeights = new HashMap<String, Double>();
        String[] stringArray = catArr;
        int n = catArr.length;
        int n2 = 0;
        while (n2 < n) {
            cat = stringArray[n2];
            this.categorySet.add(cat);
            this.categoryWeights.put(cat, 1.0);
            ++n2;
        }
        categories = "wind_farm,tunnel_opening,solar_farm,nuclear_powerplant,military_facility,crop_field,airport,flooded_road,debris_or_rubble,single-unit_residential";
        stringArray = catArr = categories.split(",");
        n = catArr.length;
        n2 = 0;
        while (n2 < n) {
            cat = stringArray[n2];
            this.categoryWeights.put(cat, 0.6);
            ++n2;
        }
        categories = "border_checkpoint,construction_site,educational_institution,factory_or_powerplant,fire_station,police_station,gas_station,smokestack,tower,road_bridge";
        stringArray = catArr = categories.split(",");
        n = catArr.length;
        n2 = 0;
        while (n2 < n) {
            cat = stringArray[n2];
            this.categoryWeights.put(cat, 1.4);
            ++n2;
        }
        this.categorySet.add(FALSE_DETECTION);
        this.categoryWeights.put(FALSE_DETECTION, 0.0);
        this.jsonBuilder = new GsonBuilder();
        this.jsonBuilder.setPrettyPrinting();
        this.gson = this.jsonBuilder.create();
        if (this.sceneFilter != null) {
            this.sceneFilterPattern = Pattern.compile(this.sceneFilter);
        }
        this.loadTruth();
        if (this.createTOC) {
            this.createTOC();
            this.log("TOC file created, re-run application without the -toc setting.");
            System.exit(0);
        }
        this.loadSolution();
        for (int b : this.boxIdToCategory.keySet()) {
            String cat2 = this.boxIdToCategory.get(b);
            if (!cat2.equals(FALSE_DETECTION_ALIAS)) continue;
            this.boxIdToCategory.put(b, FALSE_DETECTION);
        }
        for (int b : this.boxIdToGuess.keySet()) {
            String cat3 = this.boxIdToGuess.get(b);
            if (!cat3.equals(FALSE_DETECTION_ALIAS)) continue;
            this.boxIdToGuess.put(b, FALSE_DETECTION);
        }
        this.categoryToScore = new HashMap<String, Metrics>();
        if (this.boxIdToCategory.isEmpty() || this.boxIdToGuess.isEmpty()) {
            this.log("Nothing to score");
        } else {
            for (int boxId : this.boxIdToCategory.keySet()) {
                Scene s;
                String guess;
                String category = this.boxIdToCategory.get(boxId);
                Metrics m = this.categoryToScore.get(category);
                if (m == null) {
                    m = new Metrics();
                    this.categoryToScore.put(category, m);
                }
                if (category.equals(guess = this.boxIdToGuess.get(boxId))) {
                    ++m.tp;
                    continue;
                }
                ++m.fn;
                Metrics mGuess = this.categoryToScore.get(guess);
                if (mGuess == null) {
                    mGuess = new Metrics();
                    this.categoryToScore.put(guess, mGuess);
                }
                ++mGuess.fp;
                String sceneId = this.boxIdToSceneId.get(boxId);
                if (sceneId == null || (s = this.sceneIdToScene.get(sceneId)) == null) continue;
                s.isError = true;
                s.guess = guess;
            }
            if (this.categoryToScore.isEmpty() || this.categoryToScore.size() == 1 && this.categoryToScore.containsKey(FALSE_DETECTION)) {
                this.log("Nothing to score");
            } else {
                String scoreText = this.getScoreText();
                this.log(scoreText);
            }
        }
        if (!this.hasGui) {
            return;
        }
        if (this.categoryToScore.isEmpty()) {
            this.errorsOnlyCb.setEnabled(false);
        }
        this.writeImageList(false);
        this.logArea.setCaretPosition(0);
        this.currentScene = this.scenes[0];
        this.loadImage(this.currentScene.tList.get(0));
        this.repaintMap();
    }

    private void createTOC() {
        try {
            HashMap<String, HashSet<Integer>> sceneIdToBoxIds = new HashMap<String, HashSet<Integer>>();
            for (int boxId : this.boxIdToSceneId.keySet()) {
                String sceneId = this.boxIdToSceneId.get(boxId);
                HashSet<Integer> ids = (HashSet<Integer>)sceneIdToBoxIds.get(sceneId);
                if (ids == null) {
                    ids = new HashSet<Integer>();
                    sceneIdToBoxIds.put(sceneId, ids);
                }
                ids.add(boxId);
            }
            String dataDirPath = new File(this.dataDir).getCanonicalPath();
            int len = dataDirPath.length();
            this.tocWriter = new PrintWriter(new BufferedWriter(new FileWriter(new File(this.dataDir, TOC_FILE_NAME))));
            Scene[] sceneArray = this.scenes;
            int n = this.scenes.length;
            int n2 = 0;
            while (n2 < n) {
                Scene scene = sceneArray[n2];
                StringBuilder sb = new StringBuilder();
                sb.append(scene.id);
                String path = scene.dir.getCanonicalPath().substring(len);
                sb.append("\t").append(path);
                sb.append("\t");
                for (int tmpid : scene.tList) {
                    sb.append(tmpid).append(";");
                }
                Set ids = (Set)sceneIdToBoxIds.get(scene.id);
                Iterator iterator = ids.iterator();
                while (iterator.hasNext()) {
                    int id = (Integer)iterator.next();
                    sb.append("\t").append(id).append(";").append(this.boxIdToCategory.get(id));
                }
                sb.append("\n");
                this.tocWriter.print(sb.toString());
                ++n2;
            }
            this.tocWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getScoreText() {
        Object[] categories = this.categoryToScore.keySet().toArray(new String[0]);
        Arrays.sort(categories);
        StringBuilder sb = new StringBuilder();
        double fSum = 0.0;
        double wSum = 0.0;
        Object[] objectArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            Object cat = objectArray[n2];
            Metrics m = this.categoryToScore.get(cat);
            m.calculate();
            double w = this.categoryWeights.get(cat);
            fSum += m.fScore * w;
            wSum += w;
            ++n2;
        }
        double f = 0.0;
        if (wSum > 0.0) {
            f = fSum / wSum;
        }
        sb.append("\nOverall F-score : " + Utils.f6(f)).append("\n");
        sb.append("  " + this.pad("--category--", 16) + "F-score; TP; FP; FN; precision; recall; weight").append("\n");
        Object[] objectArray2 = categories;
        int n3 = categories.length;
        int n4 = 0;
        while (n4 < n3) {
            Object cat = objectArray2[n4];
            Metrics m = this.categoryToScore.get(cat);
            sb.append("  ").append(this.pad((String)cat, 16)).append(Utils.f(m.fScore)).append("; ").append(m.tp).append("; ").append(m.fp).append("; ").append(m.fn).append("; ").append(Utils.f(m.precision)).append("; ").append(Utils.f(m.recall)).append("; ").append(Utils.f(this.categoryWeights.get(cat))).append("\n");
            ++n4;
        }
        return sb.toString();
    }

    private String pad(String s, int len) {
        if (s.length() > len - 1) {
            s = s.substring(0, len - 1);
        }
        while (s.length() < len) {
            s = String.valueOf(s) + " ";
        }
        return s;
    }

    private void loadTruth() {
        this.log("Reading truth data from " + this.dataDir + " ...");
        this.boxIdToCategory = new HashMap<Integer, String>();
        this.boxIdToSceneId = new HashMap<Integer, String>();
        this.sceneIdToScene = new HashMap<String, Scene>();
        if (!this.createTOC && new File(this.dataDir, TOC_FILE_NAME).exists()) {
            this.log("  using TOC file");
            this.loadTruthFromToc();
        } else {
            this.recurseTruthDir(new File(this.dataDir));
        }
        this.scenes = this.sceneIdToScene.values().toArray(new Scene[0]);
        Arrays.sort(this.scenes);
        if (this.writeSolution) {
            this.writeSolution();
        }
    }

    private void loadTruthFromToc() {
        try {
            String line;
            String dataDirPath = new File(this.dataDir).getCanonicalPath();
            boolean hasLimit = this.maxNperCategory < Integer.MAX_VALUE;
            HashMap<String, Integer> categoryCounts = new HashMap<String, Integer>();
            if (hasLimit) {
                for (String cat : this.categorySet) {
                    categoryCounts.put(cat, 0);
                }
            }
            LineNumberReader lnr = new LineNumberReader(new FileReader(new File(this.dataDir, TOC_FILE_NAME)));
            while ((line = lnr.readLine()) != null) {
                String[] tIds;
                Matcher m;
                String[] parts = line.split("\t");
                String sceneId = parts[0];
                if (this.sceneFilterPattern != null && !(m = this.sceneFilterPattern.matcher(sceneId)).find()) continue;
                if (hasLimit) {
                    String cat = parts[3].split(";")[1];
                    if (this.categorySet.contains(cat) && (Integer)categoryCounts.get(cat) >= this.maxNperCategory) continue;
                    int cnt = (Integer)categoryCounts.get(cat);
                    categoryCounts.put(cat, cnt + 1);
                }
                Scene scene = new Scene();
                scene.id = sceneId;
                scene.dir = new File(String.valueOf(dataDirPath) + parts[1]);
                String[] stringArray = tIds = parts[2].split(";");
                int n = tIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String t = stringArray[n2];
                    scene.tList.add(Integer.parseInt(t));
                    ++n2;
                }
                this.sceneIdToScene.put(sceneId, scene);
                int i = 3;
                while (i < parts.length) {
                    String[] boxCat = parts[i].split(";");
                    int boxId = Integer.parseInt(boxCat[0]);
                    String cat = boxCat[1];
                    this.boxIdToCategory.put(boxId, cat);
                    this.boxIdToSceneId.put(boxId, sceneId);
                    ++i;
                }
            }
            lnr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void recurseTruthDir(File dir) {
        int dirCnt = 0;
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                this.recurseTruthDir(f);
                if (++dirCnt == this.maxNperCategory && this.categorySet.contains(dir.getName())) {
                    break;
                }
            } else {
                String suffix;
                String string = suffix = this.useMsData ? "_msrgb.json" : "_rgb.json";
                if (f.getName().endsWith(suffix)) {
                    Matcher m;
                    String imageName = f.getName();
                    String[] parts = imageName.split("_");
                    int n3 = parts.length;
                    String sceneId = "";
                    int i = 0;
                    while (i < n3 - 2) {
                        sceneId = String.valueOf(sceneId) + parts[i];
                        if (i < n3 - 3) {
                            sceneId = String.valueOf(sceneId) + "_";
                        }
                        ++i;
                    }
                    if (this.sceneFilterPattern == null || (m = this.sceneFilterPattern.matcher(sceneId)).find()) {
                        int timeId = Integer.parseInt(parts[n3 - 2]);
                        imageName = imageName.replace(".json", ".jpg");
                        File imageF = new File(dir, imageName);
                        Scene scene = null;
                        if (!imageF.exists()) {
                            this.log("Image file " + sceneId + " not found");
                        } else {
                            scene = this.sceneIdToScene.get(sceneId);
                            if (scene == null) {
                                scene = new Scene();
                                scene.id = sceneId;
                                scene.dir = dir;
                                this.sceneIdToScene.put(sceneId, scene);
                            }
                            scene.tList.add(timeId);
                            try {
                                MetaData md = this.gson.fromJson((Reader)new FileReader(f), MetaData.class);
                                Box[] boxArray = md.bounding_boxes;
                                int n4 = md.bounding_boxes.length;
                                int n5 = 0;
                                while (n5 < n4) {
                                    Box b = boxArray[n5];
                                    int id = b.ID;
                                    String cat = b.category;
                                    if (cat == null) {
                                        cat = FALSE_DETECTION;
                                    }
                                    this.boxIdToCategory.put(id, cat);
                                    this.boxIdToSceneId.put(id, sceneId);
                                    ++n5;
                                }
                            }
                            catch (Exception e) {
                                this.log("Error reading meta data from " + f.getAbsolutePath());
                                e.printStackTrace();
                                System.exit(1);
                            }
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private void writeSolution() {
        try {
            FileOutputStream out = new FileOutputStream("solution.txt");
            for (int id : this.boxIdToCategory.keySet()) {
                String cat = this.boxIdToCategory.get(id);
                String line = String.valueOf(id) + "," + cat + "\n";
                out.write(line.getBytes());
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadSolution() {
        this.boxIdToGuess = new HashMap<Integer, String>();
        if (this.solutionPath == null) {
            this.log("No solution file given.");
            return;
        }
        this.log("Reading solution data from " + this.solutionPath + " ...");
        List<String> lines = Utils.readTextLines(this.solutionPath);
        int lineNo = 0;
        for (String line : lines) {
            ++lineNo;
            String[] parts = line.split(",");
            if (parts.length != 2) {
                FmowVisualizer.exit("Wrong format at line " + lineNo + " : " + line);
            }
            int boxId = Integer.parseInt(parts[0].trim());
            String guess = parts[1].trim();
            if (!this.categorySet.contains(guess)) {
                FmowVisualizer.exit("Unknown category at line " + lineNo + " : " + guess);
            }
            this.boxIdToGuess.put(boxId, guess);
        }
        Iterator<Object> iterator = this.boxIdToCategory.keySet().iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            if (this.boxIdToGuess.containsKey(id)) continue;
            FmowVisualizer.exit("No prediction found for: " + id);
        }
    }

    private void getBestRulerIndex() {
        int wBest = this.mapView.getWidth() / 4;
        double bestDiff = Double.MAX_VALUE;
        int i = 0;
        while (i < this.rulerLengths.length) {
            double w = this.rulerLengths[i] / this.currentGsd / this.scale;
            double diff = Math.abs(w - (double)wBest);
            if (diff < bestDiff) {
                bestDiff = diff;
                this.rulerIndex = i;
            }
            ++i;
        }
    }

    public void setupGUI(int W) {
        if (!this.hasGui) {
            return;
        }
        this.frame = new JFrame(TITLE);
        int H = W * 2 / 3;
        this.frame.setSize(W, H);
        this.frame.setResizable(false);
        this.frame.setDefaultCloseOperation(3);
        Container cp = this.frame.getContentPane();
        cp.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 2.0;
        c.weighty = 1.0;
        this.viewPanel = new JPanel();
        this.viewPanel.setPreferredSize(new Dimension(H, H));
        cp.add((Component)this.viewPanel, c);
        c.fill = 1;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        this.controlsPanel = new JPanel();
        cp.add((Component)this.controlsPanel, c);
        this.viewPanel.setLayout(new BorderLayout());
        this.mapView = new MapView();
        this.viewPanel.add((Component)this.mapView, "Center");
        this.controlsPanel.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        int y = 0;
        this.showBoxesCb = new JCheckBox("Show bounding boxes");
        this.showBoxesCb.setSelected(true);
        this.showBoxesCb.addActionListener(this);
        c2.fill = 1;
        c2.gridx = 0;
        c2.gridy = y++;
        c2.weightx = 1.0;
        this.controlsPanel.add((Component)this.showBoxesCb, c2);
        this.showLabelsCb = new JCheckBox("Show category labels");
        this.showLabelsCb.setSelected(true);
        this.showLabelsCb.addActionListener(this);
        c2.gridy = y++;
        this.controlsPanel.add((Component)this.showLabelsCb, c2);
        this.showBoxIdsCb = new JCheckBox("Show box IDs");
        this.showBoxIdsCb.setSelected(true);
        this.showBoxIdsCb.addActionListener(this);
        c2.gridy = y++;
        this.controlsPanel.add((Component)this.showBoxIdsCb, c2);
        this.errorsOnlyCb = new JCheckBox("Show only images with error");
        this.errorsOnlyCb.setSelected(false);
        this.errorsOnlyCb.addActionListener(this);
        c2.gridy = y++;
        this.controlsPanel.add((Component)this.errorsOnlyCb, c2);
        this.xyInfoLabel = new JLabel(" XYZ: ");
        c2.gridy = y++;
        this.controlsPanel.add((Component)this.xyInfoLabel, c2);
        JScrollPane sp = new JScrollPane();
        this.logArea = new JTextArea("", 10, 20);
        this.logArea.setFont(new Font("Monospaced", 0, 16));
        this.logArea.addMouseListener(this);
        sp.getViewport().setView(this.logArea);
        c2.gridy = y++;
        c2.weighty = 10.0;
        this.controlsPanel.add((Component)sp, c2);
        sp = new JScrollPane();
        this.infoArea = new JTextArea("", 10, 20);
        this.infoArea.setFont(new Font("Monospaced", 0, 16));
        this.infoArea.addMouseListener(this);
        sp.getViewport().setView(this.infoArea);
        c2.gridy = y++;
        c2.weighty = 5.0;
        this.controlsPanel.add((Component)sp, c2);
        this.frame.setVisible(true);
    }

    private void loadImage(int t) {
        String name = String.valueOf(this.currentScene.id) + "_" + t + "_";
        name = String.valueOf(name) + (this.useMsData ? "msrgb.jpg" : "rgb.jpg");
        this.frame.setTitle("fMoW Visualizer - " + name);
        File f = new File(this.currentScene.dir, name);
        try {
            BufferedImage img = ImageIO.read(f);
            int w = img.getWidth();
            int h = img.getHeight();
            this.currentMapData = new MapData(w, h);
            int i = 0;
            while (i < w) {
                int j = 0;
                while (j < h) {
                    int c;
                    this.currentMapData.pixels[i][j] = c = img.getRGB(i, j);
                    ++j;
                }
                ++i;
            }
            this.scale = (double)this.currentMapData.W / (double)this.mapView.getWidth();
            this.x0 = 0.0;
            this.y0 = 0.0;
        }
        catch (Exception e) {
            this.log("Error reading image from " + f.getAbsolutePath());
            e.printStackTrace();
        }
        String metaPath = f.getAbsolutePath().replace(".jpg", ".json");
        f = new File(metaPath);
        try {
            MetaData md = this.gson.fromJson((Reader)new FileReader(f), MetaData.class);
            this.currentGsd = md.gsd;
            Box[] boxArray = this.currentBoxes = md.bounding_boxes;
            int n = this.currentBoxes.length;
            int n2 = 0;
            while (n2 < n) {
                Box b = boxArray[n2];
                if (b.category == null || b.category.equals(FALSE_DETECTION_ALIAS)) {
                    b.category = FALSE_DETECTION;
                }
                b.guess = this.boxIdToGuess.get(b.ID);
                ++n2;
            }
            this.getBestRulerIndex();
            String formatted = this.gson.toJson(md);
            this.infoArea.setText(formatted);
            this.infoArea.setCaretPosition(0);
        }
        catch (Exception e) {
            this.log("Error reading meta data from " + f.getAbsolutePath());
            e.printStackTrace();
            System.exit(1);
        }
        this.frame.repaint();
    }

    private void refreshLogArea(boolean errorsOnly) {
        this.logArea.setText("");
        String scoreText = this.getScoreText();
        this.logArea.append(scoreText);
        this.writeImageList(errorsOnly);
        this.logArea.setCaretPosition(0);
    }

    private void writeImageList(boolean errorsOnly) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n========\n Images\n========\n");
        Scene[] sceneArray = this.scenes;
        int n = this.scenes.length;
        int n2 = 0;
        while (n2 < n) {
            Scene s = sceneArray[n2];
            if (s.isError || !errorsOnly) {
                sb.append(s.isError ? " * " : "   ");
                sb.append(s.id);
                for (int t : s.tList) {
                    sb.append(" _").append(t);
                }
                if (s.isError && s.guess != null) {
                    sb.append(ARROW).append(s.guess);
                }
                sb.append("\n");
            }
            ++n2;
        }
        this.logArea.append(sb.toString());
    }

    private void repaintMap() {
        if (this.mapView != null) {
            this.mapView.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.showBoxesCb || e.getSource() == this.showLabelsCb || e.getSource() == this.showBoxIdsCb) {
            this.showLabelsCb.setEnabled(this.showBoxesCb.isSelected());
            this.showBoxIdsCb.setEnabled(this.showBoxesCb.isSelected());
            this.repaintMap();
        } else if (e.getSource() == this.errorsOnlyCb) {
            this.refreshLogArea(this.errorsOnlyCb.isSelected());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() != this.logArea) {
            return;
        }
        try {
            int lineIndex = this.logArea.getLineOfOffset(this.logArea.getCaretPosition());
            int start = this.logArea.getLineStartOffset(lineIndex);
            int end = this.logArea.getLineEndOffset(lineIndex);
            String line = this.logArea.getDocument().getText(start, end - start);
            if (line.length() < 3) {
                return;
            }
            line = line.substring(3);
            int pos = this.logArea.getCaretPosition() - start - 3;
            String[] parts = line.split(" ");
            if (parts.length < 2) {
                return;
            }
            String id = parts[0];
            Scene scene = this.sceneIdToScene.get(id);
            if (scene == null) {
                return;
            }
            int len = parts[0].length();
            int tIndex = 0;
            int i = 1;
            while (i < parts.length) {
                if (pos <= (len += 1 + parts[i].length())) {
                    tIndex = i - 1;
                    break;
                }
                ++i;
            }
            if (tIndex >= scene.tList.size()) {
                tIndex = scene.tList.size() - 1;
            }
            this.currentScene = scene;
            this.loadImage(scene.tList.get(tIndex));
            this.repaintMap();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void log(String s) {
        if (this.logArea != null) {
            this.logArea.append(String.valueOf(s) + "\n");
        }
        System.out.println(s);
    }

    private static void exit(String s) {
        System.out.println(s);
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        boolean setDefaults = true;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-no-defaults")) {
                setDefaults = false;
            }
            ++i;
        }
        FmowVisualizer v = new FmowVisualizer();
        v.hasGui = true;
        int w = 1500;
        if (setDefaults) {
            v.createTOC = false;
            v.hasGui = true;
            w = 1500;
            v.solutionPath = null;
            v.dataDir = null;
        } else {
            v.dataDir = "c:/tmp/topcoder-fmow/0912";
        }
        int i2 = 0;
        while (i2 < args.length) {
            if (args[i2].equals("-toc")) {
                v.createTOC = true;
            }
            if (args[i2].equals("-no-gui")) {
                v.hasGui = false;
            }
            if (args[i2].equals("-w")) {
                w = Integer.parseInt(args[i2 + 1]);
            }
            if (args[i2].equals("-solution")) {
                v.solutionPath = args[i2 + 1];
            }
            if (args[i2].equals("-data-dir")) {
                v.dataDir = args[i2 + 1];
            }
            if (args[i2].equals("-no-ms")) {
                v.useMsData = false;
            }
            if (args[i2].equals("-max-per-cat")) {
                v.maxNperCategory = Integer.parseInt(args[i2 + 1]);
            }
            if (args[i2].equals("-scene-filter")) {
                v.sceneFilter = args[i2 + 1];
            }
            ++i2;
        }
        if (v.dataDir == null) {
            FmowVisualizer.exit("Data folder not set, use -data-dir");
        }
        if (v.createTOC) {
            v.log("Creating TOC file, ignoring all other settings");
            v.hasGui = false;
            v.solutionPath = null;
            v.maxNperCategory = Integer.MAX_VALUE;
            v.sceneFilter = null;
        }
        v.setupGUI(w);
        v.run();
    }

    public class Box {
        public int ID;
        public String category;
        public int[] box;
        public transient String guess;
    }

    private class MapData {
        public int W;
        public int H;
        public int[][] pixels;

        public MapData(int w, int h) {
            this.W = w;
            this.H = h;
            this.pixels = new int[this.W][this.H];
        }
    }

    private class MapView
    extends JLabel
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private int mouseX;
        private int mouseY;
        private BufferedImage image;
        private int invalidColor = 3315400;
        private int M = 5;

        public MapView() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
        }

        @Override
        public void paint(Graphics gr) {
            int rulerW;
            int c;
            int j;
            if (FmowVisualizer.this.currentMapData == null) {
                return;
            }
            int W = this.getWidth();
            int H = this.getHeight();
            if (this.image == null) {
                this.image = new BufferedImage(W, H, 1);
            }
            MapData mapData = FmowVisualizer.this.currentMapData;
            Graphics2D g2 = (Graphics2D)gr;
            g2.setFont(FmowVisualizer.this.font);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            int i = 0;
            while (i < W) {
                j = 0;
                while (j < H) {
                    c = this.invalidColor;
                    int mapI = (int)(((double)i - FmowVisualizer.this.x0) * FmowVisualizer.this.scale);
                    int mapJ = (int)(((double)j - FmowVisualizer.this.y0) * FmowVisualizer.this.scale);
                    if (mapI >= 0 && mapJ >= 0 && mapI < mapData.W && mapJ < mapData.H) {
                        c = mapData.pixels[mapI][mapJ];
                    }
                    this.image.setRGB(i, j, c);
                    ++j;
                }
                ++i;
            }
            g2.drawImage((Image)this.image, 0, 0, null);
            if (FmowVisualizer.this.showBoxesCb.isSelected() && FmowVisualizer.this.currentBoxes != null) {
                Box[] mapI = FmowVisualizer.this.currentBoxes;
                c = mapI.length;
                j = 0;
                while (j < c) {
                    double maxy;
                    double miny;
                    double maxx;
                    Box b = mapI[j];
                    double minx = (double)b.box[0] / FmowVisualizer.this.scale + FmowVisualizer.this.x0;
                    if (!(minx > (double)this.getWidth() || (maxx = (double)(b.box[0] + b.box[2]) / FmowVisualizer.this.scale + FmowVisualizer.this.x0) < 0.0 || (miny = (double)b.box[1] / FmowVisualizer.this.scale + FmowVisualizer.this.y0) > (double)this.getHeight() || (maxy = (double)(b.box[1] + b.box[3]) / FmowVisualizer.this.scale + FmowVisualizer.this.y0) < 0.0)) {
                        String label;
                        int x = (int)minx;
                        int y = (int)miny;
                        int w = (int)(maxx - (double)x);
                        int h = (int)(maxy - (double)y);
                        g2.setColor(FmowVisualizer.this.borderColorBlack);
                        g2.drawRect(x - 1, y - 1, w + 2, h + 2);
                        g2.setColor(FmowVisualizer.this.borderColorWhite);
                        g2.drawRect(x, y, w, h);
                        if (FmowVisualizer.this.showLabelsCb.isSelected()) {
                            label = b.category;
                            if (b.guess != null && !b.guess.equals(b.category)) {
                                label = String.valueOf(label) + FmowVisualizer.ARROW + b.guess;
                            }
                            w = this.textWidth(label, g2) + 2 * this.M;
                            h = FmowVisualizer.this.font.getSize() + 2 * this.M;
                            g2.setColor(FmowVisualizer.this.borderColorWhite);
                            g2.fillRect(x, y, w, h);
                            g2.setColor(FmowVisualizer.this.textColor);
                            g2.drawString(label, x + this.M, y + h - this.M);
                        }
                        if (FmowVisualizer.this.showBoxIdsCb.isSelected()) {
                            label = String.valueOf(b.ID);
                            w = this.textWidth(label, g2) + 2 * this.M;
                            h = FmowVisualizer.this.font.getSize() + 2 * this.M;
                            g2.setColor(FmowVisualizer.this.borderColorWhite);
                            int yRect = (int)maxy - h;
                            g2.fillRect(x, yRect, w, h);
                            g2.setColor(FmowVisualizer.this.textColor);
                            g2.drawString(label, x + this.M, yRect + h - this.M);
                        }
                    }
                    ++j;
                }
            }
            if ((rulerW = (int)(FmowVisualizer.this.rulerLengths[FmowVisualizer.this.rulerIndex] / FmowVisualizer.this.currentGsd / FmowVisualizer.this.scale)) < W / 2 && rulerW > 3 * this.M) {
                String label = FmowVisualizer.this.rulerLabels[FmowVisualizer.this.rulerIndex];
                int w = rulerW + 3 * this.M + this.textWidth(label, g2);
                int h = FmowVisualizer.this.font.getSize() + 2 * this.M;
                g2.setColor(FmowVisualizer.this.borderColorWhite);
                g2.fillRect(this.M, H - this.M - h, w, h);
                g2.setColor(FmowVisualizer.this.textColor);
                g2.drawLine(2 * this.M, H - this.M - h / 2, 2 * this.M + rulerW, H - this.M - h / 2);
                g2.drawString(label, 3 * this.M + rulerW, H - 2 * this.M);
            }
        }

        private int textWidth(String text, Graphics2D g) {
            FontRenderContext context = g.getFontRenderContext();
            Rectangle2D r = FmowVisualizer.this.font.getStringBounds(text, context);
            return (int)r.getWidth();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            FmowVisualizer.this.repaintMap();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.setCursor(Cursor.getPredefinedCursor(1));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            this.mouseX = x;
            this.mouseY = y;
            FmowVisualizer.this.repaintMap();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            FmowVisualizer fmowVisualizer = FmowVisualizer.this;
            fmowVisualizer.x0 = fmowVisualizer.x0 + (double)(x - this.mouseX);
            FmowVisualizer fmowVisualizer2 = FmowVisualizer.this;
            fmowVisualizer2.y0 = fmowVisualizer2.y0 + (double)(y - this.mouseY);
            this.mouseX = x;
            this.mouseY = y;
            FmowVisualizer.this.repaintMap();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (FmowVisualizer.this.currentMapData == null) {
                return;
            }
            int x = e.getX();
            int y = e.getY();
            int i = (int)(((double)x - FmowVisualizer.this.x0) * FmowVisualizer.this.scale);
            int j = (int)(((double)y - FmowVisualizer.this.y0) * FmowVisualizer.this.scale);
            String info = "";
            if (i >= 0 && j >= 0 && i < ((FmowVisualizer)FmowVisualizer.this).currentMapData.W && j < ((FmowVisualizer)FmowVisualizer.this).currentMapData.H) {
                info = String.valueOf(i) + ", " + j;
            }
            FmowVisualizer.this.xyInfoLabel.setText(" XY: " + info);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            this.mouseX = e.getX();
            this.mouseY = e.getY();
            double dataX = ((double)this.mouseX - FmowVisualizer.this.x0) * FmowVisualizer.this.scale;
            double dataY = ((double)this.mouseY - FmowVisualizer.this.y0) * FmowVisualizer.this.scale;
            double change = Math.pow(2.0, 0.5);
            if (e.getWheelRotation() > 0) {
                FmowVisualizer fmowVisualizer = FmowVisualizer.this;
                fmowVisualizer.scale = fmowVisualizer.scale * change;
            }
            if (e.getWheelRotation() < 0) {
                FmowVisualizer fmowVisualizer = FmowVisualizer.this;
                fmowVisualizer.scale = fmowVisualizer.scale / change;
            }
            FmowVisualizer.this.x0 = (double)this.mouseX - dataX / FmowVisualizer.this.scale;
            FmowVisualizer.this.y0 = (double)this.mouseY - dataY / FmowVisualizer.this.scale;
            FmowVisualizer.this.getBestRulerIndex();
            FmowVisualizer.this.repaintMap();
        }
    }

    private class Metrics {
        public int tp;
        public int fp;
        public int fn;
        public double precision = 0.0;
        public double recall = 0.0;
        public double fScore = 0.0;

        private Metrics() {
        }

        public void calculate() {
            if (this.tp + this.fp > 0) {
                this.precision = (double)this.tp / (double)(this.tp + this.fp);
            }
            if (this.tp + this.fn > 0) {
                this.recall = (double)this.tp / (double)(this.tp + this.fn);
            }
            if (this.precision + this.recall > 0.0) {
                this.fScore = 2.0 * this.precision * this.recall / (this.precision + this.recall);
            }
        }
    }

    private class Scene
    implements Comparable<Scene> {
        public String id;
        public boolean isError;
        public File dir;
        public List<Integer> tList = new Vector<Integer>();
        public String guess;

        private Scene() {
        }

        @Override
        public int compareTo(Scene o) {
            return this.id.compareTo(o.id);
        }
    }
}

